/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class CssBorderFaceWidthCSS2 {
    CssValue value;
    private static CssIdent thin = new CssIdent("thin");
    private static CssIdent medium = new CssIdent("medium");
    private static CssIdent thick = new CssIdent("thick");

    public CssBorderFaceWidthCSS2() {
        this.value = medium;
    }

    public CssBorderFaceWidthCSS2(CssBorderFaceWidthCSS2 another) {
        this.value = another.value;
    }

    public CssBorderFaceWidthCSS2(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 6: {
                float f = ((Float)val.get()).floatValue();
                if (f >= 0.0f) {
                    this.value = val;
                    break;
                }
                throw new InvalidParamException("negative-value", val.toString(), ac);
            }
            case 5: {
                this.value = ((CssNumber)val).getLength();
                break;
            }
            case 0: {
                CssIdent ci = (CssIdent)val;
                if (CssProperty.inherit.equals(ci)) {
                    this.value = CssProperty.inherit;
                    break;
                }
                if (thin.equals(ci)) {
                    this.value = thin;
                    break;
                }
                if (medium.equals(ci)) {
                    this.value = medium;
                    break;
                }
                if (thick.equals(ci)) {
                    this.value = thick;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", val.toString(), "width", ac);
            }
        }
        expression.next();
    }

    public CssBorderFaceWidthCSS2(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssValue getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "";
    }

    public boolean equals(CssBorderFaceWidthCSS2 another) {
        return this.value.equals(another.value);
    }
}

